import pandas as pd
import numpy as np
import pickle

atp_tennis = pd.read_csv('atp_tennis.csv')

# Retrieve unique surface types
surface_types = atp_tennis['Surface'].unique()

# Initialize an empty dataframe for storing the results   
columns = ['Player', 'Opponent', 'Win Rate', 'Head-to-Head'] + [f'{surface} Surface Performance' for surface in surface_types]   
player_stats = pd.DataFrame(columns=columns)   

# Loop through Federer's opponents   
for opponent in federer_opponents:   
    # Calculate win rate, head-to-head record, and surface performance for Raonic M. against each opponent   
    win_rate, h2h_record, surface_performance = calculate_performance('Raonic M.', opponent, atp_tennis, surface_types)   

    # Append the results to the dataframe   
    row_data = {'Player': 'Raonic M.', 'Opponent': opponent, 'Win Rate': win_rate, 'Head-to-Head': h2h_record}   
    row_data.update({f'{surface} Surface Performance': surface_performance[surface] for surface in surface_types})   
    player_stats = pd.concat([player_stats, pd.DataFrame(row_data, index=[0])], ignore_index=True)   

# Display the resulting dataframe   
print(player_stats)
pickle.dump(player_stats,open("./ref_result/player_stats.pkl","wb"))